/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_13;

import java.io.FileWriter;
import java.io.IOException;

import djbuch.kapitel_06.DemoTools;
import org.apache.log4j.PropertyConfigurator;
import org.shiftone.cache.Cache;
import org.shiftone.cache.CacheConfiguration;
import org.shiftone.cache.CacheFactory;
import org.shiftone.cache.ConfigurationException;
/**
 * Einfacher Singleton, der auf Basis des ShiftOne Object Cache
 * (www.shiftone.org) einen Cache zur Verfgung stellt.
 * @author Thomas Ekert
 */
public class DJCache {
	
	private Cache cache = null;

	private static final DJCache singleton = new DJCache ();
	private static final long TIMEOUT_IN_MILLIS = 1000 * 60 * 1;
	private static final int MAX_OBJECTS_IN_CACHE = 500;
	private static final String NAME_DES_CACHE = "DJCache";
	private static final String BASENAME = "cache.properties";

	private DJCache (){
		try {
			CacheConfiguration config = new CacheConfiguration(makeConfig ());
			/* In der Datei cache.properties sind drei mgliche Caches
			 * vorkonfiguriert
			 * lru - least recently used - Am wenigsten Benutzte Objekte werden aus dem Cache entfernt
			 * statLru - Erweitert lru und liefert statistische Ausgaben bei Auflsung des Caches
			 * syncLru - Erweitert statLru und ist zustzlich synchronized
			 */
			//CacheFactory factory = config.getCacheFactory("lru");
			//CacheFactory factory = config.getCacheFactory("statLru");
			CacheFactory factory = config.getCacheFactory("syncLru");
			cache=factory.newInstance(NAME_DES_CACHE, TIMEOUT_IN_MILLIS,
					MAX_OBJECTS_IN_CACHE);
		} catch (ConfigurationException e) {
			e.printStackTrace(System.err);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public static final Cache getCache () {
		return DJCache.singleton.cache;
	}
	
	protected String makeConfig() throws IOException {
		String filename = BASENAME;
		String basePath = DemoTools.replaceSubstring(System.getProperty("user.dir"),"\\","/") + "/java/";
		basePath = basePath==null?"":basePath;
		if (DemoTools.exists(basePath + filename)) {
			System.out.println ("Loading DJCache Config from file: "+ basePath+filename);
			PropertyConfigurator.configure (basePath+filename);
		} else {
			System.out.println ("Generating NEW DJCache Default Config in file: "+ basePath+filename);
			DemoTools.makeDir(basePath);
			FileWriter fw = new FileWriter(basePath+filename);
			fw.write(AUTO_CONFIG);
			fw.flush();
			fw.close();
			fw = null;
		}
		return basePath+filename;
	}

	
	private static final String AUTO_CONFIG = "title               = ShiftOne Object Cache\n"
		+ "version             = 2.0b\n"
		+ "\n"
		+ "# ------ [ Cache Configurations ] ----------------------------------------\n"
		+ "\n"
		+ "# Default cache configurations\n"
		+ "cache.factory                                       = lru\n"
		+ "cache.timeout                                       = 10000\n"
		+ "cache.maxsize                                       = 1000\n"
		+ "\n"
		+ "# Exception cache configurations\n"
		+ "cache.timeout.net.sf                                = 9999\n"
		+ "cache.maxsize.org.shiftone                          = 999\n"
		+ "\n"
		+ "# ------ [ Factory Configurations ] --------------------------------------\n"
		+ "\n"
		+ "# LRU (least recently used)\n"
		+ "factory.lru                         = org.shiftone.cache.policy.lru.LruCacheFactory\n"
		+ "\n"
		+ "# statLRU (least recently used with statistical output)\n"
		+ "factory.statLru                     = org.shiftone.cache.decorator.stat.StatCacheFactory\n"
		+ "factory.statLru.delegate            = lru\n"
		+ "\n"
		+ "# SyncLRU (synchronized least recently used with statistical output)\n"
		+ "factory.syncLru                     = org.shiftone.cache.decorator.sync.SyncCacheFactory\n"
		+ "factory.syncLru.delegate            = statLru\n";
}
